/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;

public abstract class QueuedRuleBasedScanner
extends RuleBasedScanner {
    protected final Queue<Entry> queue = new LinkedList<Entry>();
    private Entry fCurrentEntry;

    public void queueToken(IToken token, int offset, int length) {
        this.queue.add(new Entry(null, token, offset, length));
    }

    public void queueDelegate(ITokenScanner tokenScanner, int offset, int length) {
        tokenScanner.setRange(this.fDocument, offset, length);
        this.queue.add(new Entry(tokenScanner, null, offset, length));
    }

    public void setRange(IDocument document, int offset, int length) {
        this.queue.clear();
        super.setRange(document, offset, length);
    }

    public IToken nextToken() {
        while (!this.queue.isEmpty()) {
            this.fCurrentEntry = this.queue.element();
            IToken token = this.fCurrentEntry.nextToken();
            if (token != Token.EOF) {
                return token;
            }
            this.queue.remove();
        }
        this.fCurrentEntry = null;
        return super.nextToken();
    }

    public int getTokenOffset() {
        if (this.fCurrentEntry != null) {
            return this.fCurrentEntry.getTokenOffset();
        }
        if (!this.queue.isEmpty()) {
            return this.queue.element().getTokenOffset();
        }
        return super.getTokenOffset();
    }

    public int getTokenLength() {
        if (this.fCurrentEntry != null) {
            return this.fCurrentEntry.getTokenLength();
        }
        if (!this.queue.isEmpty()) {
            return this.queue.element().getTokenLength();
        }
        return super.getTokenLength();
    }

    protected static class Entry {
        private final ITokenScanner tokenScanner;
        private IToken token;
        private final int offset;
        private final int length;

        public Entry(ITokenScanner tokenScanner, IToken token, int offset, int length) {
            this.tokenScanner = tokenScanner;
            this.token = token;
            this.offset = offset;
            this.length = length;
        }

        public IToken nextToken() {
            if (this.tokenScanner != null) {
                return this.tokenScanner.nextToken();
            }
            try {
                IToken iToken = this.token;
                return iToken;
            }
            finally {
                this.token = Token.EOF;
            }
        }

        public int getTokenOffset() {
            if (this.tokenScanner != null) {
                return this.tokenScanner.getTokenOffset();
            }
            return this.offset;
        }

        public int getTokenLength() {
            if (this.tokenScanner != null) {
                return this.tokenScanner.getTokenLength();
            }
            return this.length;
        }

        public String toString() {
            return MessageFormat.format("[{0}, {1}]: {2}", this.offset, this.length, this.token.getData());
        }
    }
}

